/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.serialize.java;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Objects;
import org.apache.wicket.Application;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.application.IClassResolver;
import org.apache.wicket.core.util.objects.checker.CheckingObjectOutputStream;
import org.apache.wicket.core.util.objects.checker.ObjectSerializationChecker;
import org.apache.wicket.serialize.ISerializer;
import org.apache.wicket.settings.ApplicationSettings;
import org.apache.wicket.util.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSerializer
implements ISerializer {
    private static final Logger log = LoggerFactory.getLogger(JavaSerializer.class);
    private static final StackWalker STACKWALKER;
    private static final ClassLoader PLATFORM_CLASS_LOADER;
    private final String applicationKey;

    public JavaSerializer(String applicationKey) {
        this.applicationKey = applicationKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] serialize(Object object) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream oos = null;
            try {
                oos = this.newObjectOutputStream(out);
                oos.writeObject(this.applicationKey);
                oos.writeObject(object);
            }
            finally {
                try {
                    IOUtils.close((Closeable)oos);
                }
                finally {
                    out.close();
                }
            }
            return out.toByteArray();
        }
        catch (Exception e) {
            log.error("Error serializing object {} [object={}]", new Object[]{object.getClass(), object, e});
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object deserialize(byte[] data) {
        ThreadContext old = ThreadContext.get(false);
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        ObjectInputStream ois = null;
        try {
            Object object;
            Application oldApplication = ThreadContext.getApplication();
            try {
                Application app;
                ois = this.newObjectInputStream(in);
                String applicationName = (String)ois.readObject();
                if (applicationName != null && (app = Application.get(applicationName)) != null) {
                    ThreadContext.setApplication(app);
                }
                object = ois.readObject();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ThreadContext.setApplication(oldApplication);
                        IOUtils.close((Closeable)ois);
                    }
                    finally {
                        in.close();
                    }
                    throw throwable;
                }
                catch (IOException | ClassNotFoundException cnfx) {
                    throw new WicketRuntimeException("Could not deserialize object from byte[]", cnfx);
                }
            }
            try {
                ThreadContext.setApplication(oldApplication);
                IOUtils.close((Closeable)ois);
            }
            finally {
                in.close();
            }
            return object;
        }
        finally {
            ThreadContext.restore(old);
        }
    }

    protected ObjectInputStream newObjectInputStream(InputStream in) throws IOException {
        return new ClassResolverObjectInputStream(in);
    }

    protected ObjectOutputStream newObjectOutputStream(OutputStream out) throws IOException {
        return new SerializationCheckerObjectOutputStream(out);
    }

    static {
        PrivilegedAction<StackWalker> pa1 = () -> StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        PrivilegedAction<ClassLoader> pa2 = ClassLoader::getPlatformClassLoader;
        STACKWALKER = AccessController.doPrivileged(pa1);
        PLATFORM_CLASS_LOADER = AccessController.doPrivileged(pa2);
    }

    private static class ClassResolverObjectInputStream
    extends ObjectInputStream {
        public ClassResolverObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                return super.resolveClass(desc);
            }
            catch (ClassNotFoundException cnfEx) {
                log.debug("Class not found by the object outputstream itself, trying the IClassResolver");
                Class<?> candidate = this.resolveClassInWicket(desc.getName());
                if (candidate == null) {
                    throw cnfEx;
                }
                return candidate;
            }
        }

        private Class<?> resolveClassByName(String className, ClassLoader latestUserDefined) throws ClassNotFoundException {
            try {
                return Class.forName(className, false, latestUserDefined);
            }
            catch (ClassNotFoundException cnfEx) {
                Class<?> ret = this.resolveClassInWicket(className);
                if (ret == null) {
                    throw cnfEx;
                }
                return ret;
            }
        }

        private Class<?> resolveClassInWicket(String className) throws ClassNotFoundException {
            Class<?> candidate;
            try {
                Application application = Application.get();
                ApplicationSettings applicationSettings = application.getApplicationSettings();
                IClassResolver classResolver = applicationSettings.getClassResolver();
                candidate = classResolver.resolveClass(className);
            }
            catch (WicketRuntimeException ex) {
                if (ex.getCause() instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)ex.getCause();
                }
                ClassNotFoundException wrapperCnf = new ClassNotFoundException();
                wrapperCnf.initCause(ex);
                throw wrapperCnf;
            }
            return candidate;
        }

        @Override
        protected Class<?> resolveProxyClass(String[] interfaces) throws ClassNotFoundException, IOException {
            try {
                return super.resolveProxyClass(interfaces);
            }
            catch (ClassNotFoundException cnfEx) {
                log.debug("Proxy Class not found by the ObjectOutputStream itself, trying the IClassResolver");
                ClassLoader latestLoader = ClassResolverObjectInputStream.latestUserDefinedLoader();
                ClassLoader nonPublicLoader = null;
                boolean hasNonPublicInterface = false;
                Class[] classObjs = new Class[interfaces.length];
                for (int i = 0; i < interfaces.length; ++i) {
                    Class<?> cl = this.resolveClassByName(interfaces[i], latestLoader);
                    if ((cl.getModifiers() & 1) == 0) {
                        if (hasNonPublicInterface) {
                            if (nonPublicLoader != cl.getClassLoader()) {
                                throw new IllegalAccessError("conflicting non-public interface class loaders");
                            }
                        } else {
                            nonPublicLoader = cl.getClassLoader();
                            hasNonPublicInterface = true;
                        }
                    }
                    classObjs[i] = cl;
                }
                try {
                    InvocationHandler invocationHandler = (proxy, method, args) -> null;
                    Object proxyInstance = Proxy.newProxyInstance(hasNonPublicInterface ? nonPublicLoader : latestLoader, classObjs, invocationHandler);
                    return proxyInstance.getClass();
                }
                catch (IllegalArgumentException e) {
                    throw new ClassNotFoundException(null, e);
                }
            }
        }

        private static ClassLoader latestUserDefinedLoader() {
            try {
                return STACKWALKER.walk(s -> s.map(StackWalker.StackFrame::getDeclaringClass).map(Class::getClassLoader).filter(Objects::nonNull).filter(cl -> !PLATFORM_CLASS_LOADER.equals(cl)).findFirst().orElse(PLATFORM_CLASS_LOADER));
            }
            catch (IllegalArgumentException | SecurityException e) {
                throw new WicketRuntimeException(e);
            }
        }
    }

    private static class SerializationCheckerObjectOutputStream
    extends ObjectOutputStream {
        private final OutputStream outputStream;
        private final ObjectOutputStream oos;

        private SerializationCheckerObjectOutputStream(OutputStream outputStream) throws IOException {
            this.outputStream = outputStream;
            this.oos = new ObjectOutputStream(outputStream);
        }

        @Override
        protected final void writeObjectOverride(Object obj) throws IOException {
            try {
                this.oos.writeObject(obj);
            }
            catch (NotSerializableException nsx) {
                if (CheckingObjectOutputStream.isAvailable()) {
                    try {
                        CheckingObjectOutputStream checkingObjectOutputStream = new CheckingObjectOutputStream(this.outputStream, new ObjectSerializationChecker(nsx));
                        checkingObjectOutputStream.writeObject(obj);
                    }
                    catch (CheckingObjectOutputStream.ObjectCheckException x) {
                        throw x;
                    }
                    catch (Exception x) {
                        x.initCause(nsx);
                        throw new WicketRuntimeException("A problem occurred while trying to collect debug information about not serializable object", x);
                    }
                    throw nsx;
                }
                throw nsx;
            }
            catch (Exception e) {
                log.error("error writing object {} : {}", new Object[]{obj, e.getMessage(), e});
                throw new WicketRuntimeException(e);
            }
        }

        @Override
        public void flush() throws IOException {
            this.oos.flush();
        }

        @Override
        public void close() throws IOException {
            this.oos.close();
        }
    }
}

