/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.log;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.propertytypes.ServiceRanking;
import org.osgi.service.http.whiteboard.Preprocessor;

@Component(service={Preprocessor.class})
@ServiceRanking(value=0x7FFFFFFF)
public class RequestLoggerPreprocessor
implements Preprocessor {
    private static final String ATTR_NAME = Preprocessor.class.getName() + ".startTime";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        request.setAttribute(ATTR_NAME, (Object)System.currentTimeMillis());
        try {
            chain.doFilter(request, response);
        }
        finally {
            request.removeAttribute(ATTR_NAME);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public static long getRequestStartTime(ServletRequest request) {
        Object val;
        Object object = val = request == null ? null : request.getAttribute(ATTR_NAME);
        if (val instanceof Long) {
            return (Long)val;
        }
        return System.currentTimeMillis();
    }
}

