/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.impl.vlt;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.nodetype.NodeType;
import org.apache.sling.ide.impl.vlt.VltNodeType;
import org.apache.sling.ide.impl.vlt.VltNodeTypeFactory;
import org.apache.sling.ide.impl.vlt.VltRepository;
import org.apache.sling.ide.transport.NodeTypeRegistry;
import org.apache.sling.ide.transport.RepositoryException;

public class VltNodeTypeRegistry
implements NodeTypeRegistry {
    private Map<String, VltNodeType> nodeTypes = new HashMap<String, VltNodeType>();

    public VltNodeTypeRegistry(VltRepository repo) throws RepositoryException {
        VltNodeTypeFactory factory = new VltNodeTypeFactory();
        factory.init(repo);
        this.nodeTypes = factory.getNodeTypes();
    }

    public boolean isAllowedPrimaryChildNodeType(String parentNodeType, String childNodeType) throws RepositoryException {
        Set<String> allowedChildren = this.getNodeType(parentNodeType).getAllowedPrimaryChildNodeTypes();
        return allowedChildren.contains(childNodeType);
    }

    public Collection<String> getAllowedPrimaryChildNodeTypes(String parentNodeType) throws RepositoryException {
        Set<String> allowedChildren = this.getNodeType(parentNodeType).getAllowedPrimaryChildNodeTypes();
        return Collections.unmodifiableCollection(allowedChildren);
    }

    public List<NodeType> getNodeTypes() {
        LinkedList<NodeType> result = new LinkedList<NodeType>();
        for (VltNodeType nt : this.nodeTypes.values()) {
            result.add(nt);
        }
        return result;
    }

    public VltNodeType getNodeType(String name) {
        return this.nodeTypes.get(name);
    }
}

