/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.Context;
import org.apache.juneau.annotation.TargetedAnnotationTBuilder;
import org.apache.juneau.annotation.TargetedAnnotationTImpl;
import org.apache.juneau.html.annotation.HtmlLink;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.svl.VarResolverSession;

public class HtmlLinkAnnotation {
    public static final HtmlLink DEFAULT = HtmlLinkAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return HtmlLinkAnnotation.create().on((Class[])on);
    }

    public static Builder create(String ... on) {
        return HtmlLinkAnnotation.create().on(on);
    }

    public static HtmlLink copy(HtmlLink a, VarResolverSession r) {
        return ((Builder)HtmlLinkAnnotation.create().nameProperty(r.resolve(a.nameProperty())).on(r.resolve(a.on())).onClass((Class[])a.onClass())).uriProperty(r.resolve(a.uriProperty())).build();
    }

    public static class Builder
    extends TargetedAnnotationTBuilder {
        String nameProperty = "";
        String uriProperty = "";

        protected Builder() {
            super(HtmlLink.class);
        }

        public HtmlLink build() {
            return new Impl(this);
        }

        public Builder nameProperty(String value) {
            this.nameProperty = value;
            return this;
        }

        public Builder uriProperty(String value) {
            this.uriProperty = value;
            return this;
        }

        @Override
        public Builder on(String ... values) {
            super.on(values);
            return this;
        }

        @Override
        public Builder on(Class<?> ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder onClass(Class<?> ... value) {
            super.onClass(value);
            return this;
        }
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public HtmlLink[] value();
    }

    public static class Apply
    extends AnnotationApplier<HtmlLink, Context.Builder> {
        public Apply(VarResolverSession vr) {
            super(HtmlLink.class, Context.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<HtmlLink> ai, Context.Builder b) {
            HtmlLink a = ai.inner();
            if (ArrayUtils.isEmptyArray(a.on(), a.onClass())) {
                return;
            }
            b.annotations(HtmlLinkAnnotation.copy(a, this.vr()));
        }
    }

    private static class Impl
    extends TargetedAnnotationTImpl
    implements HtmlLink {
        private final String nameProperty;
        private final String uriProperty;

        Impl(Builder b) {
            super(b);
            this.nameProperty = b.nameProperty;
            this.uriProperty = b.uriProperty;
            this.postConstruct();
        }

        @Override
        public String nameProperty() {
            return this.nameProperty;
        }

        @Override
        public String uriProperty() {
            return this.uriProperty;
        }
    }
}

