/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client;

import java.util.Locale;
import org.apache.juneau.http.HttpMethod;

public class RestOperation {
    public static final Object NO_BODY = "NO_BODY";
    private final Object url;
    private final String method;
    private final Object content;
    private boolean hasContent;

    public static RestOperation of(String method, Object url) {
        return new RestOperation(method, url, NO_BODY);
    }

    public static RestOperation of(String method, Object url, Object body) {
        return new RestOperation(method, url, body);
    }

    public RestOperation(String method, Object url, Object body) {
        this.url = url;
        this.method = method.toUpperCase(Locale.ENGLISH);
        this.content = body;
        this.hasContent = HttpMethod.hasContent((String)method);
    }

    public Object getUri() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public Object getContent() {
        return this.content;
    }

    public boolean hasContent() {
        return this.hasContent;
    }

    public RestOperation hasContent(boolean value) {
        this.hasContent = value;
        return this;
    }
}

