/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.validator.AbstractCommonTest;
import org.apache.commons.validator.TypeBean;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResults;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.xml.sax.SAXException;

class GenericTypeValidatorTest
extends AbstractCommonTest {
    protected static final String FORM_KEY = "typeForm";
    protected static final String ACTION = "byte";

    GenericTypeValidatorTest() {
    }

    private Map<String, ?> localeTest(TypeBean info, Locale locale) throws ValidatorException {
        Validator validator = new Validator(this.resources, "typeLocaleForm");
        validator.setParameter("java.lang.Object", (Object)info);
        validator.setParameter("java.util.Locale", (Object)locale);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        Map hResultValues = results.getResultValueMap();
        Assertions.assertInstanceOf(Byte.class, hResultValues.get(ACTION), (String)("Expecting byte result to be an instance of Byte for locale: " + locale));
        Assertions.assertInstanceOf(Short.class, hResultValues.get("short"), (String)("Expecting short result to be an instance of Short for locale: " + locale));
        Assertions.assertInstanceOf(Integer.class, hResultValues.get("integer"), (String)("Expecting integer result to be an instance of Integer for locale: " + locale));
        Assertions.assertInstanceOf(Long.class, hResultValues.get("long"), (String)("Expecting long result to be an instance of Long for locale: " + locale));
        Assertions.assertInstanceOf(Float.class, hResultValues.get("float"), (String)("Expecting float result to be an instance of Float for locale: " + locale));
        Assertions.assertInstanceOf(Double.class, hResultValues.get("double"), (String)("Expecting double result to be an instance of Double for locale: " + locale));
        Assertions.assertInstanceOf(Date.class, hResultValues.get("date"), (String)("Expecting date result to be an instance of Date for locale: " + locale));
        for (String key : hResultValues.keySet()) {
            Object value = hResultValues.get(key);
            Assertions.assertNotNull(value, (String)("value ValidatorResults.getResultValueMap() should not be null for locale: " + locale));
        }
        return hResultValues;
    }

    @BeforeEach
    protected void setUp() throws IOException, SAXException {
        this.loadResources("GenericTypeValidatorTest-config.xml");
    }

    @AfterEach
    protected void tearDown() {
    }

    @Test
    void testFRLocale() throws ValidatorException {
        TypeBean info = new TypeBean();
        info.setByte("12");
        info.setShort("-129");
        info.setInteger("1443");
        info.setLong("88000");
        info.setFloat("12,1555");
        info.setDouble("129,1551511111");
        info.setDate("21/12/2010");
        Map<String, ?> map = this.localeTest(info, Locale.FRENCH);
        Assertions.assertEquals((int)12, (int)((Float)map.get("float")).intValue(), (String)"float value not correct");
        Assertions.assertEquals((int)129, (int)((Double)map.get("double")).intValue(), (String)"double value not correct");
    }

    @Test
    void testType() throws ValidatorException {
        TypeBean info = new TypeBean();
        info.setByte("12");
        info.setShort("129");
        info.setInteger("-144");
        info.setLong("88000");
        info.setFloat("12.1555f");
        info.setDouble("129.1551511111d");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)info);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        Map hResultValues = results.getResultValueMap();
        Assertions.assertInstanceOf(Byte.class, hResultValues.get(ACTION), (String)"Expecting byte result to be an instance of Byte.");
        Assertions.assertInstanceOf(Short.class, hResultValues.get("short"), (String)"Expecting short result to be an instance of Short.");
        Assertions.assertInstanceOf(Integer.class, hResultValues.get("integer"), (String)"Expecting integer result to be an instance of Integer.");
        Assertions.assertInstanceOf(Long.class, hResultValues.get("long"), (String)"Expecting long result to be an instance of Long.");
        Assertions.assertInstanceOf(Float.class, hResultValues.get("float"), (String)"Expecting float result to be an instance of Float.");
        Assertions.assertInstanceOf(Double.class, hResultValues.get("double"), (String)"Expecting double result to be an instance of Double.");
        for (String key : hResultValues.keySet()) {
            Object value = hResultValues.get(key);
            Assertions.assertNotNull(value, (String)"value ValidatorResults.getResultValueMap() should not be null.");
        }
    }

    @Test
    void testUSLocale() throws ValidatorException {
        TypeBean info = new TypeBean();
        info.setByte("12");
        info.setShort("129");
        info.setInteger("-144");
        info.setLong("88000");
        info.setFloat("12.1555");
        info.setDouble("129.1551511111");
        info.setDate("12/21/2010");
        this.localeTest(info, Locale.US);
    }
}

