/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.util.ResourceBundle;
import org.apache.commons.text.lookup.AbstractStringLookup;
import org.apache.commons.text.lookup.ResourceBundleStringLookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ResourceBundleStringLookupTest {
    private static final String KEY = "key";
    private static final String TEST_RESOURCE_BUNDLE = "org.apache.commons.text.example.testResourceBundleLookup";

    ResourceBundleStringLookupTest() {
    }

    @Test
    void testAny() {
        String bundleName = TEST_RESOURCE_BUNDLE;
        String bundleKey = KEY;
        Assertions.assertEquals((Object)ResourceBundle.getBundle(TEST_RESOURCE_BUNDLE).getString(KEY), (Object)ResourceBundleStringLookup.INSTANCE.apply(AbstractStringLookup.toLookupKey((String)TEST_RESOURCE_BUNDLE, (String)KEY)));
    }

    @Test
    void testBadKey() {
        String bundleName = TEST_RESOURCE_BUNDLE;
        String bundleKey = "bad_key";
        Assertions.assertNull((Object)new ResourceBundleStringLookup(TEST_RESOURCE_BUNDLE).apply("bad_key"));
        Assertions.assertNull((Object)ResourceBundleStringLookup.INSTANCE.apply(AbstractStringLookup.toLookupKey((String)TEST_RESOURCE_BUNDLE, (String)"bad_key")));
    }

    @Test
    void testBadNames() {
        Assertions.assertNull((Object)ResourceBundleStringLookup.INSTANCE.apply(AbstractStringLookup.toLookupKey((String)"BAD_RESOURCE_BUNDLE_NAME", (String)"KEY")));
    }

    @Test
    void testDoubleBundle() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ResourceBundleStringLookup(TEST_RESOURCE_BUNDLE).apply(AbstractStringLookup.toLookupKey((String)"OtherBundle", (String)KEY)));
    }

    @Test
    void testExceptionGettingString() {
        ResourceBundleStringLookup mockLookup = (ResourceBundleStringLookup)Mockito.spy(ResourceBundleStringLookup.class);
        Mockito.when((Object)mockLookup.getString(TEST_RESOURCE_BUNDLE, KEY)).thenThrow(ClassCastException.class);
        Assertions.assertThrows(IllegalArgumentException.class, () -> mockLookup.apply(AbstractStringLookup.toLookupKey((String)TEST_RESOURCE_BUNDLE, (String)KEY)));
    }

    @Test
    void testMissingKeyInSpec() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ResourceBundleStringLookup.INSTANCE.apply("org.apache.commons.text.example.testResourceBundleLookup:"));
    }

    @Test
    void testNull() {
        Assertions.assertNull((Object)ResourceBundleStringLookup.INSTANCE.apply(null));
    }

    @Test
    void testOne() {
        Assertions.assertEquals((Object)ResourceBundle.getBundle(TEST_RESOURCE_BUNDLE).getString(KEY), (Object)new ResourceBundleStringLookup(TEST_RESOURCE_BUNDLE).apply(KEY));
    }

    @Test
    void testToString() {
        Assertions.assertFalse((boolean)ResourceBundleStringLookup.INSTANCE.toString().isEmpty());
    }
}

