/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.perf.test.reflect;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Random;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.perf.test.BasicArrayState;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

public class ReflectNestedFloatArrayTest {
    private static final int ARRAY_SIZE = 10;

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public void encode(TestStateEncode state) throws Exception {
        for (NativeArrayWrapper r : state.testData) {
            state.datumWriter.write(r, state.encoder);
        }
    }

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public void decode(Blackhole blackhole, TestStateDecode state) throws Exception {
        Decoder d = state.decoder;
        ReflectDatumReader datumReader = new ReflectDatumReader(state.schema);
        for (int i = 0; i < state.getBatchSize(); ++i) {
            blackhole.consume(datumReader.read(null, d));
        }
    }

    static float[] populateFloatArray(Random r, int size) {
        float[] result = new float[size];
        for (int i = 0; i < result.length; ++i) {
            result[i] = r.nextFloat();
        }
        return result;
    }

    @State(value=Scope.Thread)
    public static class TestStateEncode
    extends BasicArrayState {
        private final Schema schema;
        private NativeArrayWrapper[] testData;
        private Encoder encoder;
        private ReflectDatumWriter<NativeArrayWrapper> datumWriter;

        public TestStateEncode() {
            super(10);
            String jsonText = ReflectData.get().getSchema((Type)((Object)NativeArrayWrapper.class)).toString();
            this.schema = new Schema.Parser().parse(jsonText);
        }

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws Exception {
            this.encoder = super.newEncoder(false, this.getNullOutputStream());
            this.datumWriter = new ReflectDatumWriter(this.schema);
            this.testData = new NativeArrayWrapper[this.getBatchSize()];
            for (int i = 0; i < this.testData.length; ++i) {
                NativeArrayWrapper wrapper = new NativeArrayWrapper();
                wrapper.value = ReflectNestedFloatArrayTest.populateFloatArray(this.getRandom(), this.getArraySize());
                this.testData[i] = wrapper;
            }
        }
    }

    static class NativeArrayWrapper {
        float[] value;

        NativeArrayWrapper() {
        }
    }

    @State(value=Scope.Thread)
    public static class TestStateDecode
    extends BasicArrayState {
        private final Schema schema;
        private byte[] testData;
        private Decoder decoder;

        public TestStateDecode() {
            super(10);
            String jsonText = ReflectData.get().getSchema((Type)((Object)float[].class)).toString();
            this.schema = new Schema.Parser().parse(jsonText);
        }

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Encoder encoder = super.newEncoder(true, (OutputStream)baos);
            ReflectDatumWriter writer = new ReflectDatumWriter(this.schema);
            for (int i = 0; i < this.getBatchSize(); ++i) {
                float[] r = ReflectNestedFloatArrayTest.populateFloatArray(this.getRandom(), this.getArraySize());
                writer.write(r, encoder);
            }
            this.testData = baos.toByteArray();
        }

        @Setup(value=Level.Invocation)
        public void doSetupInvocation() throws Exception {
            this.decoder = DecoderFactory.get().validatingDecoder(this.schema, super.newDecoder(this.testData));
        }
    }
}

